#include <iostream>
#include <cstdio>
#include <cstdlib>
#include <cmath>
#include <ctime>
#include <cstring>
#include <cassert>
#include <algorithm>
#include <vector>
#include <set>
#include <map>
#include <bitset>
#include <stack>
#include <queue>
#include <deque>
#include <complex>

using namespace std;

#define pb push_back
#define mp make_pair
#define sz(s) int((s).size())
#define len(s) int((s).size())
#define all(s) (s).begin(), (s).end()
#ifdef _WIN32
#define LLD "%I64d"
#else
#define LLD "%lld"
#endif
#ifdef LOCAL42
#define eprintf(...) fprintf(stderr, __VA_ARGS__)
#else
#define eprintf(...) 42
#endif
#define y0 yy0
#define y1 yy1
#define next _next
#define prev _prev
#define rank _rank
#define link _link
#define hash _hash
#define fs first
#define sc second

typedef long long ll;
typedef long long llong;
typedef long long int64;
typedef unsigned int uint;
typedef long double ld;
typedef unsigned long long ull;
typedef unsigned long long ullong;
typedef unsigned long long lint;
typedef pair<int, int> pii;
typedef vector<int> vi;

const int inf = int(2e9) + 42;
const double eps = 1e-9;
const double pi = 4 * atan(double(1));
const int N = int(1e5) + 100;

struct tr {

	int l, r;
	int add, val;

};

int maxv;
int l[N], r[N];
int x[4 * N];
vi lst[6 * N];
tr rmq[24 * N];

inline void push(int v) {
	rmq[v].val += rmq[v].add;
	if (v < maxv) {
		rmq[v * 2].add += rmq[v].add;
		rmq[v * 2 + 1].add += rmq[v].add;
	}
	rmq[v].add = 0;
}

inline void calc(int v) {
	rmq[v].val = min(rmq[v * 2].val, rmq[v * 2 + 1].val);
}

void update(int v, int l, int r, int val) {
	push(v);
	if (rmq[v].l > r || rmq[v].r < l) {
		return;
	}
	if (rmq[v].l >= l && rmq[v].r <= r) {
		rmq[v].add += val;
		push(v);
		return;
	}
	update(v * 2, l, r, val);
	update(v * 2 + 1, l, r, val);
	calc(v);
}

int get(int v, int l, int r) {
	push(v);
	if (rmq[v].l > r || rmq[v].r < l) {
		return inf;
	}
	if (rmq[v].l >= l && rmq[v].r <= r) {
		return rmq[v].val;
	}
	return min(get(v * 2, l, r), get(v * 2 + 1, l, r));
}

inline void add(int l, int r, int sz) {
	int pl = lower_bound(x, x + sz, l) - x;
	int pr = lower_bound(x, x + sz, r) - x;
	lst[pl].pb(pr);
}

inline void solve() {
	int m, n;
	scanf("%d %d", &m, &n);
	int sz = 0;
	for (int i = 0; i < n; ++i) {
		scanf("%d %d", &l[i], &r[i]);
		if (l[i] > r[i]) {
			x[sz++] = l[i];
			x[sz++] = r[i] + m;
		} else {
			x[sz++] = l[i];
			x[sz++] = l[i] + m;
			x[sz++] = r[i];
			x[sz++] = r[i] + m;
		}
	}
	if (n > m) {
		puts("NO");
		return;
	}
	sort(x, x + sz);
	sz = unique(x, x + sz) - x;
	maxv = 1;
	while (maxv < sz) {
		maxv *= 2;
	}
	for (int i = 0; i < maxv; ++i) {
		rmq[i + maxv].add = 0;
		rmq[i + maxv].l = rmq[i + maxv].r = i;
	}
	for (int i = maxv - 1; i > 0; --i) {
		rmq[i].add = 0;
		rmq[i].l = rmq[i * 2].l;
		rmq[i].r = rmq[i * 2 + 1].r;
	}
	for (int i = 0; i < sz; ++i) {
		rmq[i + maxv].val = x[i];
	}
	for (int i = sz; i < maxv; ++i) {
		rmq[i + maxv].val = inf;
	}
	for (int i = maxv - 1; i > 0; --i) {
		calc(i);
	}
	for (int i = 0; i < sz; ++i) {
		lst[i].clear();
	}
	for (int i = 0; i < n; ++i) {
		if (l[i] > r[i]) {
			add(l[i], r[i] + m, sz);
		} else {
			add(l[i], r[i], sz);
			add(l[i] + m, r[i] + m, sz);
		}
	}
	for (int i = sz - 1; i >= 0; --i) {
		for (int j = 0; j < sz(lst[i]); ++j) {
			update(1, lst[i][j], sz - 1, -1);
		}
		int pos = lower_bound(x, x + sz, x[i] + m) - x;
		if (get(1, i, pos - 1) < x[i] - 1) {
			puts("NO");
			return;
		}
	}
	puts("YES");
}

inline int get_rand() {
	return (rand() << 15) | rand();
}

inline void gen() {
	freopen("G2.in", "w", stdout);
	cout << 20 << endl;
	for (int i = 0; i < 20; ++i) {
		cout << int(1e9) << " " << int(1e5) << endl;
		for (int j = 0; j < int(1e5); ++j) {
			cout << get_rand() % int(1e9) << " " << get_rand() % int(1e9) << endl;
		}
	}
	exit(0);
}

int main() {
	//gen();
#ifdef LOCAL42
#define TASK "G"
	freopen(TASK "2.in", "r", stdin);
	freopen(TASK ".out", "w", stdout);
#else

#endif
	int t;
	scanf("%d", &t);
	for (int i = 0; i < t; ++i) {
		solve();
	}
	eprintf("%.10lf\n", 1.0 * clock() / CLOCKS_PER_SEC);
	return 0;
}
